<?xml version="1.0"?>
<!--
$Header: movieRec.xsl, 26, 5/17/01 10:09:17 AM, Schwartz, Joe$
$NoKeywords$
-->
<!DOCTYPE stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet>
<xsl:output omit-xml-declaration="yes" method="html" indent="no"/>
<xsl:include href="movieCommon.xsl"/>

<!-- Parameters for assigning a unique names to the graphical elements
	on the page. These can be set from Java in XSLTProcessor object.
-->
<xsl:param name="movieNum" select="'default'"/>
<xsl:param name="aveRatingParam" select="'default'"/>
<xsl:param name="aveRating" select="'0'"/>
<xsl:param name="movieArtRoot" select="'cover_art'"/>
<xsl:param name="productPage" select="'default'"/>
<xsl:param name="itemIDParam" select="'default'"/>
<xsl:param name="itemID"  select="'default'"/>
<xsl:param name="predRatingParam" select="'default'"/>
<xsl:param name="predRating" select="'default'"/>
<xsl:param name="addMyListParam" select="'default'"/>
	

<xsl:template name="productURL">
	<xsl:value-of select="$productPage"/>?<xsl:value-of select="$itemIDParam"/>=<xsl:value-of select="$itemID"/>&amp;<xsl:value-of select="$aveRatingParam"/>=<xsl:value-of select="$aveRating"/>&amp;<xsl:value-of select="$predRatingParam"/>=<xsl:value-of select="$predRating"/>
</xsl:template>

<!--	Template for document root. Prevents the regurgitation of bad XML
-->
<xsl:template match="/">
	<xsl:apply-templates select="MOVIE"/>
</xsl:template>

<!-- Template for the movie: outputs a single table element
	(<td>) for inclusion in a table of movie recommendations.
-->
<xsl:template match="/MOVIE">
	<xsl:param name="prodURL">
		<xsl:call-template name="productURL"/>
	</xsl:param>
	
	<table border="0" cellspacing="0" cellpadding="0" width="287"><!--Start movie ratings table --> 
	<tr>
<!--		<td width="91" height="128" valign="top"> -->
			<!-- Movie Art --><!--
			<a id="movieLink">
				<xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute>
				<xsl:call-template name="movieArt">
					<xsl:with-param name="height" select="'121'"/>
					<xsl:with-param name="root" select="."/>
					<xsl:with-param name="altText">Go to this movie's product page!</xsl:with-param>
				</xsl:call-template>
			</a>-->
<!--			<br/>
		</td>-->
		<td width="100%" valign="top" ><!-- Display long movie name -->
			<span style="width=70;" id="greenback">
				<span id="normaltext">add to my<br/>list
					<input type="checkbox"><xsl:attribute name="name"><xsl:value-of select="$addMyListParam"/></xsl:attribute><xsl:attribute name="value"><xsl:value-of select="$itemID"/></xsl:attribute></input>
				</span>
			</span>
			<a id="movieLink" alt="Go to this movie's Product Page!"><xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute> <b>	<xsl:call-template name="movieLongName"/></b></a><br/><p/>
			<!--Ratings --> 
			<div>
				<img style="align=left" src="images/seenitrateit.gif" align="left" width="62" height="51"/>
				<!-- rating title -->
				<img name="title" src="images/spacer.gif" align="center" width="126" height="13" border="0" alt=""><xsl:attribute name="name">title<xsl:value-of select="$movieNum"/></xsl:attribute></img><br/>
				<!-- rating 'iguy' image -->
				<img src="images/iguy_null.gif" width="95" height="21" border="0"><xsl:attribute name="name">iguy<xsl:value-of select="$movieNum"/></xsl:attribute><xsl:attribute name="usemap">#iguyMap<xsl:value-of select="$movieNum"/></xsl:attribute></img><br/>
				<!-- line image for predicted rating -->
				<img src="images/spacer.gif" width="95" height="6" border="0" alt=""><xsl:attribute name="name">line<xsl:value-of select="$movieNum"/></xsl:attribute></img><br/>	
			</div><!-- END ratings div-->
			<p/><xsl:if test="$aveRating &gt; 0"><!-- Info/Interest -->
				<!-- average rating -->
				<span id="smalltext">&nbsp;<b>Average Rating : </b><xsl:value-of select="$aveRating"/></span>
				</xsl:if>
				<br/><b id="normaltext">&nbsp;Haven't seen it? Want to?</b><br/>
			
			<!-- Interest radio buttons -->
			&nbsp;<xsl:call-template name="radioButtons"><xsl:with-param name="itemNum" select="$movieNum"/></xsl:call-template>
		</td>
	</tr><!-- Movie description --><!--	
	<tr> 
		<td colspan="2" height="20" valign="top">
			<span id="movieDesc">
				<xsl:variable name="moviedesc">
					<xsl:apply-templates select="//NOTES" mode="movieDescription"/>
				</xsl:variable>
				<xsl:value-of select="substring($moviedesc,0,100)"/>...
			<b><a id="movieLink"><xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute><span id="smalltext">read more&gt;&gt;</span></a></b>
			</span>
		</td>
	</tr>-->
	</table>
	
</xsl:template>

</xsl:stylesheet>


